/**
 * Requests user permission for microphone access.
 * This page is opened in a new tab because Chrome side panels cannot request permissions directly.
 */
async function getUserPermission() {
  console.log('Requesting microphone permission...');
  const statusEl = document.getElementById('status');

  try {
    // Request microphone access
    await navigator.mediaDevices.getUserMedia({ audio: true });

    // Check if permission was granted
    const micPermission = await navigator.permissions.query({
      name: 'microphone',
    });

    if (micPermission.state === 'granted') {
      console.log('✅ Microphone permission granted');
      if (statusEl) {
        statusEl.innerHTML =
          '<span class="success">✓ Permission granted! This tab will close automatically...</span>';
      }
      // Close the tab after a short delay
      setTimeout(() => {
        window.close();
      }, 1000);
    } else {
      console.log('❌ Microphone permission denied');
      if (statusEl) {
        statusEl.textContent = '❌ Permission denied. Please try again.';
      }
    }
  } catch (error) {
    console.error('Error requesting microphone permission:', error);
    if (statusEl) {
      statusEl.textContent =
        '❌ Permission denied or error occurred. You can close this tab.';
    }
  }
}

// Wait for DOM to load, then request permission
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', getUserPermission);
} else {
  getUserPermission();
}
