/**
 * Requests user permission for microphone access.
 * This page is opened in a new tab because Chrome side panels cannot request permissions directly.
 */
async function getUserPermission() {
  console.log('Requesting microphone permission...');
  const statusEl = document.getElementById('status');
  const retryButton = document.getElementById('retry-button');

  // Reset UI state
  if (statusEl) {
    statusEl.innerHTML =
      '<span class="loading"></span><span>Demande d\'autorisation en cours...</span>';
  }
  if (retryButton) {
    retryButton.classList.remove('visible');
  }

  try {
    // Request microphone access
    await navigator.mediaDevices.getUserMedia({ audio: true });

    // Check if permission was granted
    const micPermission = await navigator.permissions.query({
      name: 'microphone',
    });

    if (micPermission.state === 'granted') {
      console.log('Microphone permission granted');
      if (statusEl) {
        statusEl.innerHTML =
          '<span class="success">Autorisation accordée. Cet onglet va se fermer...</span>';
      }
      // Close the tab after a short delay
      setTimeout(() => {
        window.close();
      }, 1500);
    } else {
      console.log('Microphone permission denied');
      showError('Autorisation refusée. Veuillez réessayer.');
    }
  } catch (error) {
    console.error('Error requesting microphone permission:', error);
    showError('Autorisation refusée ou erreur.');
  }
}

function showError(message) {
  const statusEl = document.getElementById('status');
  const retryButton = document.getElementById('retry-button');

  if (statusEl) {
    statusEl.innerHTML = `<span class="error">${message}</span>`;
  }
  if (retryButton) {
    retryButton.classList.add('visible');
  }
}

// Wait for DOM to load, then request permission
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', getUserPermission);
} else {
  getUserPermission();
}
